/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.element;

import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.InputElementBuilder;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedOverlayElementBase;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class InputWindowElement
extends AnimatedOverlayElementBase {
    private final class_243 sceneSpace;
    private final Pointing direction;
    @Nullable
    class_2960 key;
    @Nullable
    ScreenElement icon;
    @Nullable
    GuiGameElement.GuiItemRenderBuilder item;

    public InputWindowElement(class_243 sceneSpace, Pointing direction) {
        this.sceneSpace = sceneSpace;
        this.direction = direction;
    }

    public InputElementBuilder builder() {
        return new Builder();
    }

    @Override
    public void render(PonderScene scene, PonderUI screen, class_332 graphics, float partialTicks, float fade) {
        String text;
        float xFade;
        class_327 font = screen.getFontRenderer();
        int width = 0;
        int height = 0;
        float f = this.direction == Pointing.RIGHT ? -1.0f : (xFade = this.direction == Pointing.LEFT ? 1.0f : 0.0f);
        float yFade = this.direction == Pointing.DOWN ? -1.0f : (this.direction == Pointing.UP ? 1.0f : 0.0f);
        xFade *= 10.0f * (1.0f - fade);
        yFade *= 10.0f * (1.0f - fade);
        boolean hasText = this.key != null;
        boolean hasIcon = this.icon != null;
        int keyWidth = 0;
        String string = text = hasText ? PonderIndex.getLangAccess().getShared(this.key) : "";
        if (fade < 0.0625f) {
            return;
        }
        class_241 sceneToScreen = scene.getTransform().sceneToScreen(this.sceneSpace, partialTicks);
        if (hasIcon) {
            width += 24;
            height = 24;
        }
        if (hasText) {
            keyWidth = font.method_1727(text);
            width += keyWidth;
        }
        if (this.item != null) {
            width += 24;
            height = 24;
        }
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(sceneToScreen.field_1343 + xFade, sceneToScreen.field_1342 + yFade);
        PonderUI.renderSpeechBox(graphics, 0, 0, width, height, false, this.direction, true);
        if (hasText) {
            Objects.requireNonNull(font);
            graphics.method_51433(font, text, 2, (int)((float)(height - 9) / 2.0f + 2.0f), PonderPalette.WHITE.getColorObject().scaleAlpha(fade).getRGB(), false);
        }
        if (hasIcon) {
            poseStack.pushMatrix();
            poseStack.translate((float)keyWidth, 0.0f);
            poseStack.scale(1.5f, 1.5f);
            this.icon.render(graphics, 0, 0);
            poseStack.popMatrix();
        }
        if (this.item != null) {
            this.item.at(keyWidth + (hasIcon ? 24 : 0), 0.0f).render(graphics);
        }
        poseStack.popMatrix();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.item != null && !visible) {
            this.item.clear();
        }
    }

    @Override
    public void setFade(float fade) {
        super.setFade(fade);
        if (this.item != null && fade == 0.0f) {
            this.item.clear();
        }
    }

    @Override
    public void clear() {
        if (this.visible) {
            this.setVisible(false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class Builder
    implements InputElementBuilder {
        private Builder() {
        }

        @Override
        public InputElementBuilder withItem(class_1799 stack) {
            InputWindowElement.this.item = (GuiGameElement.GuiItemRenderBuilder)GuiGameElement.of(stack).scale(1.5f);
            return this;
        }

        @Override
        public InputElementBuilder leftClick() {
            InputWindowElement.this.icon = PonderGuiTextures.ICON_LMB;
            return this;
        }

        @Override
        public InputElementBuilder scroll() {
            InputWindowElement.this.icon = PonderGuiTextures.ICON_SCROLL;
            return this;
        }

        @Override
        public InputElementBuilder rightClick() {
            InputWindowElement.this.icon = PonderGuiTextures.ICON_RMB;
            return this;
        }

        @Override
        public InputElementBuilder showing(ScreenElement icon) {
            InputWindowElement.this.icon = icon;
            return this;
        }

        @Override
        public InputElementBuilder whileSneaking() {
            InputWindowElement.this.key = Ponder.asResource("sneak_and");
            return this;
        }

        @Override
        public InputElementBuilder whileCTRL() {
            InputWindowElement.this.key = Ponder.asResource("ctrl_and");
            return this;
        }
    }
}

